---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：13-混同行列（Confusion Matrix）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **speech_commandsのクラス数12**：wanted_words 10個 + silence + unknownで12クラスという記述はtrain.pyの引数定義から推定しているが、input_data.pyのprepare_words_list実装を直接確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/python/ops/confusion_matrix.py` - tf.math.confusion_matrixの主要実装
- E-02: `tensorflow/examples/speech_commands/train.py` - 混同行列の利用例（音声コマンド認識）
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧（No.13の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | confusion_matrixはlabels, predictions, num_classes, weights, dtype, nameを引数に取る | E-01（行94-99） | ○ |
| C-02 | 出力はn x nのint32 Tensor（デフォルト） | E-01（行98, 141-143） | ○ |
| C-03 | 行が正解ラベル、列が予測ラベルに対応 | E-01（行102-103） | ○ |
| C-04 | num_classesがNoneの場合はmax(predictions, labels)+1で自動計算 | E-01（行169-171） | ○ |
| C-05 | labels/predictionsはint64にキャストされる | E-01（行156-157） | ○ |
| C-06 | labelsの非負チェックが実行される | E-01（行160-163） | ○ |
| C-07 | predictionsの非負チェックが実行される | E-01（行164-167） | ○ |
| C-08 | num_classes指定時にlabels/predictionsの範囲チェックが実行される | E-01（行174-182） | ○ |
| C-09 | weightsがNoneの場合はones_likeが使用される | E-01（行191-192） | ○ |
| C-10 | scatter_ndで混同行列が構築される | E-01（行193-196） | ○ |
| C-11 | indices = stack([labels, predictions], axis=1) | E-01（行190） | ○ |
| C-12 | remove_squeezable_dimensionsでランク差1の場合にsqueezeする | E-01（行30-89） | ○ |
| C-13 | @tf_export('math.confusion_matrix')で公開される | E-01（行92） | ○ |
| C-14 | train.pyでground_truth_inputとpredicted_indicesから混同行列を生成 | E-02（行177-179） | ○ |
| C-15 | predicted_indicesはtf.argmax(logits, axis=1)で計算 | E-02（行175） | ○ |
| C-16 | eval_step_intervalのデフォルトは400 | E-02（行416） | ○ |
| C-17 | バリデーション評価でtotal_conf_matrixに累積加算 | E-02（行277-280） | ○ |
| C-18 | バリデーション結果はlogging.infoで出力 | E-02（行281） | ○ |
| C-19 | テスト結果はlogging.warnで出力 | E-02（行314） | ○ |
| C-20 | バッチサイズのデフォルトは100 | E-02（行426） | ○ |
| C-21 | wanted_wordsのデフォルトはyes,no,up,down,left,right,on,off,stop,go | E-02（行435） | ○ |
| C-22 | silence, unknownを加えた12クラス | **根拠不足（input_data.py未確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- C-22: prepare_words_listがsilenceとunknownを追加するロジックはinput_data.pyに実装されているが、本分析では未読
  - 候補：tensorflow/examples/speech_commands/input_data.py のprepare_words_list関数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - confusion_matrix関数の実装仕様はソースコードで完全に確認済み
- 0: 低リスク - train.pyにおける混同行列の利用パターンはソースコードで確認済み
- 1: 中リスク - クラス数12（wanted_words + silence + unknown）の正確性はinput_data.py要確認

## 6) レビュアーチェックリスト（最小）
- [ ] confusion_matrix関数の引数とデフォルト値がソースコードと一致しているか確認
- [ ] scatter_ndによる行列構築の仕組み（indices, values, shape）が正確に記述されているか確認
- [ ] train.pyにおけるバリデーション・テスト評価時の混同行列累積ロジックを確認
- [ ] input_data.pyのprepare_words_listでsilence/unknownが追加される仕様を確認
